#ifndef __AUTOMATIONPLUGIN_H__
#define __AUTOMATIONPLUGIN_H__

#include "PIDefines.h"
#include "SPHost.h"

class AutomationPlugin {
private:
	virtual SPErr DoAbout(void* message) = 0;
	virtual SPErr DoStartup(void* message) = 0;
	virtual SPErr DoShutdown(void* message) = 0;
	virtual SPErr DoUnload(void* message) = 0;
	virtual SPErr DoReload(void* message) = 0;
	virtual SPErr DoIt(void* message) = 0;

protected:
	SPPluginRef pluginRef;
	SPErr error;

	AutomationPlugin() : error(kSPNoError), pluginRef(NULL) {}
	~AutomationPlugin() {}
public:

	SPErr GetError(void) { return (error); }
	SPPluginRef GetPluginRef(void) { return pluginRef; }
	void SetPluginRef(SPPluginRef ref) { pluginRef = ref; }
	
	SPErr HandleMessage(char* caller, char* selector, void* message)
	{
		if (sSPBasic->IsEqual(caller, kSPInterfaceCaller))
			if (sSPBasic->IsEqual(selector, kSPInterfaceAboutSelector))
				error = DoAbout(message);
			else if (sSPBasic->IsEqual(selector, kSPInterfaceStartupSelector))
				error = DoStartup(message);
			else if (sSPBasic->IsEqual(selector, kSPInterfaceShutdownSelector))
				error = DoShutdown(message);
			else
				error = kSPBadParameterError;
		else if (sSPBasic->IsEqual(caller, kSPAccessCaller))
			if (sSPBasic->IsEqual(selector, kSPAccessReloadSelector))
				error = DoReload(message);
			else if (sSPBasic->IsEqual(selector, kSPAccessUnloadSelector))
				error = DoUnload(message);
			else
				error = kSPBadParameterError;
		else if (sSPBasic->IsEqual(caller, kPSPhotoshopCaller))
			if (sSPBasic->IsEqual(selector, kPSDoIt))
				error = DoIt(message);
			else
				error = kSPBadParameterError;
		else
			error = kSPBadParameterError;
		return (error);
	}
};

#endif
// end SPPlugin.h